// -----------------------------------------------------------------------------------------
//                      S C R E W S  &   B O L T   H E A D
//------------------------------------------------------------------------------------------
//m.miller 4.23.23
#include "shapes3.inc"
#include "screws/screws_materials.inc"



// macro for simple coil shape using a pre-plotted circle 
// 24 points normalized from -1 to 1 
#macro coil (radA,radB,turns,h,objType)
  
    #declare sPoint = sphere {<0,0,0>, radB }                              
    #declare pointDataCount = 24 ;
    #declare pointArray = array[pointDataCount] ;
    #declare pointArray[0] = <0.000, 0.000, 1.000>  ;
    #declare pointArray[1] = <-0.258, 0.000, 0.965>  ;
    #declare pointArray[2] = <-0.500, 0.000, 0.866>  ;
    #declare pointArray[3] = <-0.707, 0.000, 0.707>  ;
    #declare pointArray[4] = <-0.866, 0.000, 0.500>  ;
    #declare pointArray[5] = <-0.965, 0.000, 0.258>  ;
    #declare pointArray[6] = <-1.000, 0.000, 0.000>  ;
    #declare pointArray[7] = <-0.965, 0.000, -0.258>  ;
    #declare pointArray[8] = <-0.866, 0.000, -0.500>  ;
    #declare pointArray[9] = <-0.707, 0.000, -0.707>  ;
    #declare pointArray[10] = <-0.500, 0.000, -0.866>  ;
    #declare pointArray[11] = <-0.258, 0.000, -0.965>  ;
    #declare pointArray[12] = <0.000, 0.000, -1.000>  ;
    #declare pointArray[13] = <0.258, 0.000, -0.965>  ;
    #declare pointArray[14] = <0.500, 0.000, -0.866>  ;
    #declare pointArray[15] = <0.707, 0.000, -0.707>  ;
    #declare pointArray[16] = <0.866, 0.000, -0.500>  ;
    #declare pointArray[17] = <0.965, 0.000, -0.258>  ;
    #declare pointArray[18] = <0.999, 0.000, 0.000>  ;
    #declare pointArray[19] = <0.965, 0.000, 0.258>  ;
    #declare pointArray[20] = <0.866, 0.000, 0.500>  ;
    #declare pointArray[21] = <0.707, 0.000, 0.707>  ;
    #declare pointArray[22] = <0.500, 0.000, 0.866>  ;
    #declare pointArray[23] = <0.258, 0.000, 0.965>  ; 
    
   
    #if (objType="plotCoil")
        #declare c=pointDataCount;
        #declare yOffset = h/(pointDataCount*turns);
        #declare cnt=0;
        sphere_sweep {
        cubic_spline
        c * turns,
        #declare j=0; 
        #while (j<turns)
            #declare i=0;
            #while (i<c) 
                #declare cnt=cnt+1;
                #declare pos = pointArray[i];
                #declare nY = (cnt*yOffset);
                #declare nPos = <pos.x,pos.y + nY,pos.z>;
                nPos * radA , radB
                #declare i=i+1;
            #end 
            #declare j=j+1;
        #end
        tolerance 0.000001
        }
    #end 
    
    #if (objType="plotPoints")
        #declare c=pointDataCount;
        #declare yOffset = h/(pointDataCount*turns);
        #declare cnt=0;
        #declare j=0; 
        #while (j<turns)
            #declare i=0;
            #while (i<c) 
                #declare cnt=cnt+1;
                #declare pos = pointArray[i];
                #declare nY = (cnt*yOffset);
                #declare nPos = <pos.x,pos.y + nY,pos.z>;
                object { sPoint translate nPos * radA }
                #declare i=i+1;
            #end 
            #declare j=j+1;
        #end
    #end 
#end


#declare phillips_void =
#declare rad = .25 ;
difference { 
    #declare sc = <1.000, 1.000, 1.000> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-0.000, 1.000, 0.000> } 
    union {
        #declare sc = <0.800, 2.000, 0.800> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <1.000, 1.000, 1.000> } 
        #declare sc = <0.800, 2.000, 0.800> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <1.000, 1.000, -1.000> } 
        #declare sc = <0.800, 2.000, 0.800> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-1.000, 1.000, -1.000> } 
        #declare sc = <0.800, 2.000, 0.800> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-1.000, 1.000, 1.000> } 
        }
    scale <.5,1,.5>     
    }
      

// -----------------------------------------------------------------------------------------
//                      B O L T   W I T H   O P T   T H R E A D S  
//------------------------------------------------------------------------------------------
#macro make_bolt(rad,len,opt1)
    #declare bolt_rad=.5;
    #declare bolt_length=.5;
    #declare tread_size = (rad*bolt_rad)/4;
    #declare tread_turns = (len*bolt_length)*2 ;
    #declare thread_length = len*bolt_length ;
    
    #if (opt1=0)
        cylinder { <0,0,0>,<0,-bolt_length,0>, bolt_rad scale <rad,len,rad>} 
    #end

    #if (opt1=1)
        difference {
        object { cylinder { <0,0,0>,<0,-bolt_length,0>, bolt_rad scale <rad,len,rad> } }
        //thread cutter
        object { coil(bolt_rad*rad, tread_size, tread_turns, thread_length + tread_size , "plotCoil" ) rotate<180,0,0> }  
        }
    #end
#end



// -----------------------------------------------------------------------------------------
//                      P A N    H E A D   F L A T  
//------------------------------------------------------------------------------------------
#macro make_pan_head_flat(rad,len)
    #declare bolt_rad=.5;
    #declare bolt_length=.5; 
    #declare slot_depth =  (rad*bolt_rad)/7;
    #declare slot_offset = len/3;
    union {
       difference {
            sphere {<0,0,0>, .5 scale <rad,len,rad> translate <0,len/5,0> }
            plane { <0,1,0>, 0 }
            box {<-rad*2,slot_offset,-slot_depth>,<rad*2,len,slot_depth>}   //flat slot
       } 
   }  
#end



// -----------------------------------------------------------------------------------------
//                      P A N   H E A D   P H I L L I P S
//------------------------------------------------------------------------------------------
#macro make_pan_head_phillips(rad,len)
    #declare bolt_rad=.5;
    #declare bolt_length=.5; 
    #declare slot_depth =  (rad*bolt_rad)/6;
    #declare slot_offset = len/3;
    union {
       difference {
            sphere {<0,0,0>, .5 scale <rad,len,rad> translate <0,len/5,0> }
            plane { <0,1,0>, 0 }
            object {phillips_void scale <rad*.65,len*2,rad*.65> translate <0,0,0> }
       } 
   }  
#end 




// -----------------------------------------------------------------------------------------
//                      F L A T   H E A D   P H I L L I P S
//------------------------------------------------------------------------------------------
#macro make_flat_head_phillips(rad,len)
    #declare bolt_rad=.5;
    #declare bolt_length=.5; 
    #declare slot_depth =  (rad*bolt_rad)/3;
    #declare slot_offset = len/3;
    difference {
        union { 
            cone { <0,0,0>,rad*bolt_rad, <0,len,0>,(rad*bolt_rad)*2 } 
            sphere {<0,0,0>, 1 scale <rad,len/4,rad> translate <0,len,0> }
        } 
        object {phillips_void scale <rad*1.1,len*2,rad*1.1> translate <0,0,0> }
    }
#end 


// -----------------------------------------------------------------------------------------
//                      B O L T   H E A D  
//------------------------------------------------------------------------------------------
#macro make_bolt_head(rad,len)
    #declare bolt_rad=.5;
    #declare bolt_length=.5; 
    #declare slot_depth =  (rad*bolt_rad)/3;
    #declare slot_offset = len/3;
    #declare bolt_cut = (rad*bolt_rad)/1.2;
    difference {
        union { 
            cylinder {<0,0,0>,<0,len,0>,rad*bolt_rad }
            sphere {<0,0,0>, .5 scale <rad,len/2,rad> translate <0,len,0> }
            sphere {<0,0,0>, .5 scale <rad,len/2,rad> translate <0,0,0> }
        }
        plane { <1,0,0>, 0 translate <-bolt_cut,0,0> rotate <0,0,0>}
        plane { <1,0,0>, 0 translate <-bolt_cut,0,0> rotate <0,60,0>}
        plane { <1,0,0>, 0 translate <-bolt_cut,0,0> rotate <0,120,0>}
        plane { <1,0,0>, 0 translate <-bolt_cut,0,0> rotate <0,180,0>}
        plane { <1,0,0>, 0 translate <-bolt_cut,0,0> rotate <0,240,0>}
        plane { <1,0,0>, 0 translate <-bolt_cut,0,0> rotate <0,300,0>}
    }
#end 





// -----------------------------------------------------------------------------------------
//                      N U T  
//------------------------------------------------------------------------------------------
#macro make_nut(rad,len)
    #declare bolt_rad=.5;
    #declare bolt_length=.5; 
    #declare slot_depth =  (rad*bolt_rad)/3;
    #declare slot_offset = len/3;
    #declare bolt_cut = (rad*bolt_rad)/1.2;
    difference {
        union { 
            cylinder {<0,0,0>,<0,len,0>,rad*bolt_rad }
            sphere {<0,0,0>, .5 scale <rad,len/1.5,rad> translate <0,len,0> } 
            sphere {<0,0,0>, .5 scale <rad,len/1.5,rad> translate <0,0,0> }
        }
        plane { <1,0,0>, 0 translate <-bolt_cut,0,0> rotate <0,0,0>}
        plane { <1,0,0>, 0 translate <-bolt_cut,0,0> rotate <0,60,0>}
        plane { <1,0,0>, 0 translate <-bolt_cut,0,0> rotate <0,120,0>}
        plane { <1,0,0>, 0 translate <-bolt_cut,0,0> rotate <0,180,0>}
        plane { <1,0,0>, 0 translate <-bolt_cut,0,0> rotate <0,240,0>}
        plane { <1,0,0>, 0 translate <-bolt_cut,0,0> rotate <0,300,0>}
    }
#end 


// -----------------------------------------------------------------------------------------
//                      W A S H E R 
//------------------------------------------------------------------------------------------
#macro make_washer(rad,rad2,len)
    #declare bolt_rad=.5;
    #declare bolt_length=.5; 
    #declare slot_depth =  (rad*bolt_rad)/3;
    #declare slot_offset = len/3;

    object{ Rounded_Tube_AB( 
        <0,0,0>,            // Point_A
        <0,len,0>,          // Point_A
        rad,                // tube radius outside
        rad2,               // tube inner radius 
        rad2/5,             // border radius 
        1, 
        )
    } 
#end 